package com.tomas.ht_ydt.lib;

import android.content.DialogInterface;
import android.util.Log;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.keyence.autoid.sdk.scan.ScanManager;
import com.tomas.ht_ydt.R;


import cn.pedant.SweetAlert.SweetAlertDialog;

abstract public class Scanner extends AppCompatActivity implements ScanManager.DataListener {
    protected ScanManager mScanManager;

    protected EditText default_view = null;

    abstract public void processData(String data, DecodeResult.Result result, String codeType);

    // Create a read event.
    @Override
    public void onDataReceived(DecodeResult decodeResult) {
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                "onDataReceived() called"));
        try {


            if (default_view != null) {
                default_view.requestFocus();
            }

            // Acquire the reading result.
            DecodeResult.Result result = decodeResult.getResult();
            // Acquire the read code type.
            String codeType = decodeResult.getCodeType();
            // Acquire the read data.
            String data = decodeResult.getData();

            Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                result.toString() + "[" + codeType + "]"));

            processData(data, result, codeType);
        } catch (Exception e) {
            Toast.makeText(getApplicationContext(), e.getMessage(), Toast.LENGTH_LONG).show();
        }
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                "onDataReceived() ended"));
    }

    /*
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                "onCreate() called"));
        try {
            super.onCreate(savedInstanceState);
            //setContentView(R.layout.activity_login);
            // Create a ScanManager class instance.
            mScanManager = ScanManager.createScanManager(this);
            // Create a listener to receive a read event.
            mScanManager.addDataListener(this);
        } catch (Exception e) {
            Log.e(getString(R.string.tag), e.getMessage());
        }
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                "onCreate() ended"));
    }
    @Override
    protected void onDestroy() {
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                "onDestroy() called"));
        try {
            super.onDestroy();
            // Discard the ScanManager class instance.
            mScanManager.removeDataListener(this);
            // Discard the ScanManager class instance to release the resources.
            mScanManager.releaseScanManager();
        } catch (Exception e) {
            Log.e(getString(R.string.tag), e.getMessage());
        }
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                "onDestroy() ended"));
    }

     */

    @Override
    protected void onPause() {
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                "onPause() called"));
        super.onPause();
        try {
            // Discard the ScanManager class instance.
            mScanManager.removeDataListener(this);
            // Discard the ScanManager class instance to release the resources.
            mScanManager.releaseScanManager();
        } catch (Exception e) {
            Log.e(getString(R.string.tag), e.getMessage());
        }
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                "onPause() ended"));
    }

    @Override
    protected void onResume() {
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
            "onResume() called"));
        super.onResume();
        try {
            // Create a ScanManager class instance.
            mScanManager = ScanManager.createScanManager(this);
            // Create a listener to receive a read event.
            mScanManager.addDataListener(this);
        } catch (Exception e) {
            Log.e(getString(R.string.tag), e.getMessage());
        }
        Log.d(getString(R.string.tag), String.format("%s : %s", this.getLocalClassName(),
                "onResume() ended"));
    }

    protected void showWarning(String msg) { showDialog(msg, "WARNING", SweetAlertDialog.WARNING_TYPE, null); }
    protected void showError(String msg) { showDialog(msg, "ERROR", SweetAlertDialog.ERROR_TYPE, null); }
    protected void showSuccess(String msg) { showDialog(msg, "SUCCESS", SweetAlertDialog.SUCCESS_TYPE, null); }
    protected void showSuccess(String msg, DialogInterface.OnDismissListener cb) { showDialog(msg, "SUCCESS", SweetAlertDialog.SUCCESS_TYPE, cb); }
    protected void showInformation(String msg) { showDialog(msg, "INFO", SweetAlertDialog.NORMAL_TYPE, null); }

    protected void showDialog(String msg, String title, int type, DialogInterface.OnDismissListener callback) {
        SweetAlertDialog swal = new SweetAlertDialog(Scanner.this, type);
        if (callback != null) {
            swal.setOnDismissListener(callback);
        }
        swal.setTitleText(title)
                .setContentText(msg)
                .show();
    }
}
